/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
 * Description: PQ Quantification and Search
 */
#ifndef KVECTURBO_H
#define KVECTURBO_H

#include <cstddef>
#include <cfloat>
#include <cstddef>
#include <cstdint>
#ifdef __cplusplus
    extern "C"{
#endif

#define FLEXIBLE_ARRAY_MEMBER
#define MAXIMUM_ALIGNOF 8
#define KVEC_API_PUBLIC __attribute__((visibility("default")))

namespace PQHead {

typedef struct VectorArrayData {
    int length;       // 向量个数
    int maxLen;       // 向量最大长度
    int dim;          // 向量维度
    size_t itemSize;  // 单个向量长度
    char *items;      // length个向量首地址
} VectorArrayData;
typedef VectorArrayData *VectorArray;

typedef struct Vector {
    signed int vlen;                   // x长度
    signed short dim;                  // 向量维度
    signed short unused;               // 预留字段，暂未使用
    float x[FLEXIBLE_ARRAY_MEMBER];    // 向量
} Vector;

typedef struct PQParams {
    int pqM;             // PQ子空间数
    int pqKsub;          // 子空间聚类中心数
    int funcType;        // 距离类型
    int dim;             // 向量维度
    size_t subItemSize;  // pqTable内码字大小
    char *pqTable;       // 码本
} PQParams;


KVEC_API_PUBLIC int ComputeVectorPQCode(float *vector, const PQParams *params, unsigned char *pqCode);

KVEC_API_PUBLIC int ComputePQTable(VectorArray samples, PQParams *params);

KVEC_API_PUBLIC int GetPQDistanceTableSdc(const PQParams *params, float *pqDistanceTable);

KVEC_API_PUBLIC int GetPQDistanceTableAdc(float *vector, const PQParams *params, float *pqDistanceTable);

KVEC_API_PUBLIC int GetPQDistance(const unsigned char *basecode, const unsigned char *querycode, const PQParams *params,
                                  const float *pqDistanceTable, float *pqDistance);

}

#ifdef __cplusplus
}
#endif

#endif // KVECTURBO_H